/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.log;

import com.ibm.hwmca.fw.log.ClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLogAttributes;
import com.ibm.hwmca.fw.log.LogEntryId;
import com.ibm.hwmca.fw.log.MicrocodeLog;
import com.ibm.hwmca.fw.util.HexString;
import com.ibm.hwmca.fw.util.Trace;

public class FrameworkLog
extends MicrocodeLog {
    private static final String TRACE_MASKT = "XFRMEMLT";
    private static final String TRACE_MASKF = "XFRMEMLF";
    private static final String TRACE_MASKD = "XFRMEMLD";

    public FrameworkLog(FrameworkClassLogInfo classLogInfo, short user, short errorId, int errorReason, Throwable thrown) {
        super(classLogInfo, user, errorId, errorReason, thrown, null, null);
        this.setTowerData(FrameworkLog.getTowerData(classLogInfo, errorId, this.getErrorReason()));
        if (this instanceof FrameworkLog) {
            Trace.trace(TRACE_MASKT, "<> FrameworkLog(classLogInfo=" + classLogInfo + ",user=0x" + HexString.toHex(user, true) + ",errorId=0x" + HexString.toHex(errorId, true) + ",errorReason=0x" + HexString.toHex(errorReason, true) + ",thrown=" + thrown + ")");
        }
    }

    public FrameworkLog(FrameworkClassLogInfo classLogInfo, short errorId, Throwable thrown) {
        this(classLogInfo, 0, errorId, 0, thrown);
    }

    public FrameworkLog(FrameworkClassLogInfo classLogInfo, short errorId) {
        this(classLogInfo, 0, errorId, 0, null);
    }

    public FrameworkLog(FrameworkClassLogInfo classLogInfo, short user, short errorId, int errorReason) {
        this(classLogInfo, user, errorId, errorReason, null);
        if (this instanceof FrameworkLog) {
            Trace.trace(TRACE_MASKT, "<> FrameworkLog(classLogInfo=" + classLogInfo + ",user=0x" + HexString.toHex(user, true) + ",errorId=0x" + HexString.toHex(errorId, true) + ",errorReason=0x" + HexString.toHex(errorReason, true) + ")");
        }
    }

    public LogEntryId log(FrameworkLogAttributes attribs) {
        Trace.trace(TRACE_MASKT, "-> log(attribs=" + attribs + ")");
        if (attribs == null) {
            attribs = new FrameworkLogAttributes();
        }
        LogEntryId result = super.log(attribs);
        Trace.trace(TRACE_MASKT, "<- log()");
        return result;
    }

    public LogEntryId log() {
        return this.log(null);
    }

    private static String getTowerData(ClassLogInfo classLogInfo, short errorId, int errorReason) {
        Trace.trace(TRACE_MASKD, "-> getTowerData()");
        StringBuffer result = new StringBuffer();
        if (classLogInfo != null) {
            result.append(HexString.toHex(classLogInfo.getLogClass(), true));
            result.append(HexString.toHex(classLogInfo.getLogType(), true));
        } else {
            result.append("????");
        }
        result.append(HexString.toHex((byte)(errorId >> 8), true)).append(HexString.toHex((byte)(errorId & 0xFF), true)).append(" ").append(HexString.toHex((byte)(errorReason >> 24), true)).append(HexString.toHex((byte)(errorReason >> 16 & 0xFF), true)).append(HexString.toHex((byte)(errorReason >> 8 & 0xFF), true)).append(HexString.toHex((byte)(errorReason & 0xFF), true));
        Trace.trace(TRACE_MASKD, "<- getTowerData()");
        return result.toString().toUpperCase();
    }
}

